/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class fanucdressup {
    private ArrayList m_NRLProgram = new ArrayList(1);
    private ArrayList m_V5Properties = new ArrayList(1);
    private String m_ProgramName = new String("TPETASK");
    private boolean m_auxAxesgroup = false;

    public fanucdressup(String OutputFileName, String InputFileName) {
        String[] fileComponents;
        String[] outputComponents = OutputFileName.split("\\/");
        if (outputComponents.length > 0 && (fileComponents = outputComponents[outputComponents.length - 1].split(".")).length == 2) {
            this.m_ProgramName = fileComponents[0];
        }
        try {
            BufferedReader outputFile = new BufferedReader(new FileReader(OutputFileName));
            BufferedReader inputFile = new BufferedReader(new FileReader(InputFileName));
            String line = outputFile.readLine();
            int lineno = 0;
            while (line != null) {
                if (line.equals("")) {
                    line = outputFile.readLine();
                    continue;
                }
                this.m_NRLProgram.add(lineno, line);
                ++lineno;
                line = outputFile.readLine();
            }
            outputFile.close();
            line = inputFile.readLine();
            lineno = 0;
            while (line != null) {
                if (line.equals("")) {
                    line = inputFile.readLine();
                    continue;
                }
                this.m_V5Properties.add(lineno, line);
                String[] propertyComponents = line.split(":");
                if (propertyComponents.length == 2) {
                    String[] values;
                    String propertyValue = propertyComponents[1];
                    if (propertyComponents[0].equals("DNBRobotMotionActivity.JointPosition") && (values = propertyValue.split(" ")).length > 6) {
                        this.m_auxAxesgroup = true;
                    }
                }
                ++lineno;
                line = inputFile.readLine();
            }
            inputFile.close();
            BufferedWriter bw = new BufferedWriter(new FileWriter(OutputFileName, false));
            this.WriteVersion(bw);
            this.WriteHeader(bw);
            this.WriteProgram(bw);
            this.WritePositions(bw);
            bw.close();
        }
        catch (IOException e) {
            e.getMessage();
        }
    }

    public static void main(String[] parameters) throws NumberFormatException {
        String outputFileName = parameters[0];
        String inputFileName = parameters[1];
        fanucdressup fanucdressup2 = new fanucdressup(outputFileName, inputFileName);
    }

    public void WriteVersion(BufferedWriter bw) {
        try {
            bw.write("VERSION INFO START\n");
            bw.write("DELMIA CORP. NRL TEACH FANUC DRESSUP DOWNLOADER VERSION 5 RELEASE 17\n");
            bw.write("COPYRIGHT DELMIA CORP. 1986-2006, ALL RIGHTS RESERVED\n");
            bw.write("VERSION INFO END\n");
        }
        catch (IOException e) {
            e.getMessage();
        }
    }

    public void WriteHeader(BufferedWriter bw) {
        try {
            bw.write("DATA FILE START " + this.m_ProgramName + "\n");
            bw.write("/PROG " + this.m_ProgramName + "\n");
            bw.write("/ATTR\n");
            bw.write("OWNER           = MNEDITOR;\n");
            bw.write("COMMENT         = \"DELMIA OFFLINE PROGRAM -  Resource Id \";\n");
            bw.write("PROG_SIZE       = 0;\n");
            bw.write("CREATE          = DATE 06- 03- 17 TIME  06:56:30;\n");
            bw.write("MODIFIED        = DATE 06- 03- 17 TIME  06:56:30;\n");
            bw.write("FILE_NAME       = ;\n");
            bw.write("VERSION         = 0;\n");
            bw.write("LINE_COUNT      = 0;\n");
            bw.write("MEMORY_SIZE     = 0;\n");
            bw.write("PROTECT         = READ_WRITE;\n");
            bw.write("TCD:  STACK_SIZE        = 0,\n");
            bw.write("      TASK_PRIORITY     = 50,\n");
            bw.write("     TIME_SLICE        = 0,\n");
            bw.write("     BUSY_LAMP_OFF     = 0,\n");
            bw.write("     ABORT_REQUEST     = 0,\n");
            bw.write("     PAUSE_REQUEST     = 0;\n");
            if (this.m_auxAxesgroup) {
                bw.write("DEFAULT_GROUP   = 1,1,*,*,*;\n");
            } else {
                bw.write("DEFAULT_GROUP   = 1,*,*,*,*;\n");
            }
            bw.write("CONTROL_CODE    = 00000000 00000000;\n");
            bw.write("/APPL\n");
        }
        catch (IOException e) {
            e.getMessage();
        }
    }

    public void WriteProgram(BufferedWriter bw) {
        try {
            bw.write("/MN\n");
            int ii = 0;
            while (ii < this.m_NRLProgram.size()) {
                String lineStr = String.valueOf(ii + 1);
                String currentLine = (String)this.m_NRLProgram.get(ii);
                bw.write(lineStr + ":  " + currentLine + "\n");
                ++ii;
            }
        }
        catch (IOException e) {
            e.getMessage();
        }
    }

    public void WritePositions(BufferedWriter bw) {
        try {
            bw.write("/POS\n");
            String robotMotionActProperty = "DNBRobotMotionActivity.ActivityName";
            String turnNumber1Property = "DNBRobotMotionActivity.TurnNumber1:";
            String turnNumber4Property = "DNBRobotMotionActivity.TurnNumber4:";
            String turnNumber5Property = "DNBRobotMotionActivity.TurnNumber5:";
            String turnNumber6Property = "DNBRobotMotionActivity.TurnNumber6:";
            String configNameProperty = "DNBRobotMotionActivity.ConfigName:";
            String utoolProperty = "ToolProfile.ProfileName:";
            String uframeProperty = "ObjectFrameProfile.ProfileName:";
            String cartPosProperty = "DNBRobotMotionActivity.CartesianPosition:";
            String jointPosProperty = "DNBRobotMotionActivity.JointPosition:";
            String posRegProperty = "DNBRobotMotionActivity@PosReg:";
            String posCommentProperty = "DNBRobotMotionActivity@Pos Comment:";
            String tagNameProperty = "DNBRobotMotionActivity.TagName:";
            String targetTypeProperty = "DNBRobotMotionActivity.TargetType:";
            String propertyValue = "";
            int ii = 0;
            while (ii < this.m_V5Properties.size()) {
                String currentLine = (String)this.m_V5Properties.get(ii);
                String[] propertyComponents = currentLine.split(":");
                if (propertyComponents.length == 2) {
                    propertyValue = propertyComponents[1];
                }
                if (currentLine.startsWith(robotMotionActProperty)) {
                    int jj;
                    String posReg = "";
                    String posComment = "";
                    String uf = "";
                    String ut = "";
                    String config = "";
                    String turn1 = "";
                    String turn4 = "";
                    String turn6 = "";
                    String xval = "";
                    String yval = "";
                    String zval = "";
                    String yaw = "";
                    String pitch = "";
                    String roll = "";
                    String[] auxAxes = new String[]{"", "", "", "", "", ""};
                    String[] mainAxes = new String[]{"", "", "", "", "", ""};
                    String tagName = "";
                    String targetType = "";
                    boolean posOutput = false;
                    ++ii;
                    while (ii < this.m_V5Properties.size() && !((String)this.m_V5Properties.get(ii)).startsWith(robotMotionActProperty)) {
                        String[] values;
                        currentLine = (String)this.m_V5Properties.get(ii);
                        propertyComponents = currentLine.split(":");
                        if (propertyComponents.length == 2) {
                            propertyValue = propertyComponents[1];
                        }
                        if (currentLine.startsWith(posRegProperty)) {
                            posReg = propertyValue;
                        }
                        if (currentLine.startsWith(posCommentProperty)) {
                            posComment = propertyValue;
                        }
                        if (currentLine.startsWith(turnNumber1Property)) {
                            turn1 = propertyValue;
                        }
                        if (currentLine.startsWith(turnNumber4Property)) {
                            turn4 = propertyValue;
                        }
                        if (currentLine.startsWith(turnNumber6Property)) {
                            turn6 = propertyValue;
                        }
                        if (currentLine.startsWith(configNameProperty)) {
                            if (propertyValue.length() == 1) {
                                config = propertyValue;
                            }
                            if (propertyValue.length() == 2) {
                                config = propertyValue.substring(0, 1) + " " + propertyValue.substring(1, 2);
                            }
                            if (propertyValue.length() == 3) {
                                config = propertyValue.substring(0, 1) + " " + propertyValue.substring(1, 2) + " " + propertyValue.substring(2, 3);
                            }
                        }
                        if (currentLine.startsWith(utoolProperty)) {
                            ut = propertyValue.startsWith("UTOOL_NUM = ") ? propertyValue.substring(12, 13) : "1";
                        }
                        if (currentLine.startsWith(uframeProperty)) {
                            uf = propertyValue.startsWith("UFRAME_NUM = ") ? propertyValue.substring(13, 14) : "0";
                        }
                        if (currentLine.startsWith(cartPosProperty) && (values = propertyValue.split(" ")).length == 6) {
                            xval = this.formatValue(values[0], true);
                            yval = this.formatValue(values[1], true);
                            zval = this.formatValue(values[2], true);
                            yaw = this.formatValue(values[3], false);
                            pitch = this.formatValue(values[4], false);
                            roll = this.formatValue(values[5], false);
                        }
                        if (currentLine.startsWith(jointPosProperty)) {
                            values = propertyValue.split(" ");
                            jj = 0;
                            while (jj < 6) {
                                mainAxes[jj] = this.formatValue(values[jj], false);
                                ++jj;
                            }
                            int jj2 = 6;
                            while (jj2 < values.length) {
                                auxAxes[jj2 - 6] = this.formatValue(values[jj2], false);
                                ++jj2;
                            }
                        }
                        if (currentLine.startsWith(tagNameProperty)) {
                            tagName = propertyValue;
                        }
                        if (currentLine.startsWith(targetTypeProperty)) {
                            targetType = propertyValue;
                        }
                        ++ii;
                    }
                    --ii;
                    if (!(posReg.equals("") || uf.equals("") || ut.equals("") || config.equals("") || turn1.equals("") || turn4.equals("") || turn6.equals("") || xval.equals("") || yval.equals("") || zval.equals("") || yaw.equals("") || pitch.equals("") || roll.equals("") || targetType.equals("joint") || tagName.startsWith("PR["))) {
                        if (!posComment.equals("")) {
                            bw.write("P[" + posReg + " : \"" + posComment + "\"] {\n");
                        } else {
                            bw.write("P[" + posReg + "] {\n");
                        }
                        bw.write("   GP1:\n");
                        bw.write("  UF : " + uf + ", UT : " + ut + ",           CONFIG : '" + config + ",  " + turn1 + ", " + turn4 + ", " + turn6 + "',\n");
                        bw.write("  X = " + xval + "  mm,  Y = " + yval + "  mm,  Z = " + zval + "  mm,\n");
                        if (!auxAxes[0].equals("")) {
                            bw.write("  W = " + yaw + "  deg,  P = " + pitch + "  deg,  R = " + roll + "  deg,\n");
                        } else {
                            bw.write("  W = " + yaw + "  deg,  P = " + pitch + "  deg,  R = " + roll + "  deg\n");
                        }
                        int jj3 = 0;
                        while (jj3 < 3) {
                            if (!auxAxes[jj3].equals("")) {
                                String jNumber = String.valueOf(jj3 + 1);
                                if (jj3 == 0) {
                                    bw.write("   GP2:\n");
                                    bw.write("  UF : " + uf + ", UT : " + ut + ",\n");
                                }
                                bw.write("  J" + jNumber + "= " + auxAxes[jj3] + " mm");
                                if (auxAxes[jj3 + 1].equals("")) {
                                    bw.write("\n");
                                    break;
                                }
                                bw.write(",");
                                if (jj3 == 2) {
                                    bw.write("\n");
                                }
                            }
                            ++jj3;
                        }
                        jj = 3;
                        while (jj < 6) {
                            if (!auxAxes[jj].equals("") && !auxAxes[0].equals("")) {
                                String jNumber = String.valueOf(jj + 1);
                                bw.write("  J" + jNumber + "= " + auxAxes[jj] + " mm");
                                if (jj == 5 || auxAxes[jj + 1].equals("")) {
                                    bw.write("\n");
                                    break;
                                }
                                bw.write(",");
                            }
                            ++jj;
                        }
                        bw.write("};\n");
                    } else if (!(posReg.equals("") || uf.equals("") || ut.equals("") || config.equals("") || turn1.equals("") || turn4.equals("") || turn6.equals("") || mainAxes[0].equals("") || mainAxes[1].equals("") || mainAxes[2].equals("") || mainAxes[3].equals("") || mainAxes[4].equals("") || mainAxes[5].equals("") || !targetType.equals("joint"))) {
                        if (!posComment.equals("")) {
                            bw.write("P[" + posReg + " : \"" + posComment + "\"] {\n");
                        } else {
                            bw.write("P[" + posReg + "] {\n");
                        }
                        bw.write("   GP1:\n");
                        bw.write("  UF : " + uf + ", UT : " + ut + ",           CONFIG : '" + config + ",  " + turn1 + ", " + turn4 + ", " + turn6 + "',\n");
                        bw.write("  J1 = " + mainAxes[0] + "  deg,  J2 = " + mainAxes[1] + "  deg,  J3 = " + mainAxes[3] + "  deg,\n");
                        if (!auxAxes[0].equals("")) {
                            bw.write("  J4 = " + mainAxes[3] + "  deg,  J5 = " + mainAxes[4] + "  deg,  J6 = " + mainAxes[5] + "  deg,\n");
                        } else {
                            bw.write("  J4 = " + mainAxes[3] + "  deg,  J5 = " + mainAxes[4] + "  deg,  J6 = " + mainAxes[5] + "  deg\n");
                        }
                        int jj4 = 0;
                        while (jj4 < 3) {
                            if (!auxAxes[jj4].equals("")) {
                                String jNumber = String.valueOf(jj4 + 1);
                                if (jj4 == 0) {
                                    bw.write("   GP2:\n");
                                    bw.write("  UF : " + uf + ", UT : " + ut + ",\n");
                                }
                                bw.write("  J" + jNumber + "= " + auxAxes[jj4] + " mm");
                                if (auxAxes[jj4 + 1].equals("")) {
                                    bw.write("\n");
                                    break;
                                }
                                bw.write(",");
                                if (jj4 == 2) {
                                    bw.write("\n");
                                }
                            }
                            ++jj4;
                        }
                        jj = 3;
                        while (jj < 6) {
                            if (!auxAxes[jj].equals("") && !auxAxes[0].equals("")) {
                                String jNumber = String.valueOf(jj + 1);
                                bw.write("  J" + jNumber + "= " + auxAxes[jj] + " mm");
                                if (jj == 5 || auxAxes[jj + 1].equals("")) {
                                    bw.write("\n");
                                    break;
                                }
                                bw.write(",");
                            }
                            ++jj;
                        }
                        bw.write("};\n");
                    } else if (!tagName.startsWith("PR[")) {
                        bw.write("ERROR INFO START\n");
                        bw.write("ERROR DOWNLOADING POSITION INDEX: " + posReg + " COMMENT: " + posComment + "\n");
                        bw.write("ERROR INFO END\n");
                    }
                }
                ++ii;
            }
            bw.write("/END\n");
            bw.write("DATA FILE END\n");
        }
        catch (IOException e) {
            e.getMessage();
        }
    }

    public String formatValue(String value, boolean meters) {
        if (meters) {
            double val = Double.parseDouble(value);
            value = String.valueOf(val *= 1000.0);
        }
        String newvalue = value;
        int index = value.indexOf(".");
        if (index >= 0) {
            if (value.length() >= index + 4) {
                newvalue = value.substring(0, index) + value.substring(index, index + 4);
            }
        } else {
            newvalue = value + ".0";
        }
        return newvalue;
    }
}

